@extends('user.layouts.master')
@section('css')
    <link href="{{ asset('frontend/user/assets/css/custom.css') }}" rel="stylesheet" />
    <style>
        .typeDemoImg {
            width: 50%;
            margin: 5px;
        }
    </style>
@endsection
@section('user-content')
    @if(site_info()->instanat_verify_active == 1)
        <div class="row justify-content-center pt-4">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="text-start"><h3>Instant Verify</h3></div>
                    </div>
                    <div class="card-body text-center">
    
                        <h6 class="text-center">{{site_info()->instant_verify_note}}</h6>
                        
                        @if(Auth::user()->deposit_balance > 0)
                            <a href="{{route('user.instant-verify-my-account')}}" class="btn btn-warning btn-sm text-dark" onclick="return confirm('Are you sure?')">Instant verify My Account</a>
                        @else
                            <a href="{{route('user.deposit')}}" class="btn btn-success btn-sm text-dark" style="background:#fec30f;border:none;">Please! Deposit for instant verify.</a>
                        @endif
    
                    </div>
                </div>
            </div>
        </div>
    @endif
    
    @if(site_info()->need_user_verification == 1)
        <div class="row justify-content-center pt-4">
            <div class="col-lg-6">
                <form action="{{ route('user.account-verify-with-document-store') }}" id="account_verify_form" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card">
                        <div class="card-header pb-0">
                            <div class="text-start"><h3>Manually Account Verification</h3></div>
                            <div>
                                @if(account_verify_document() && account_verify_document()->status == 0)
                                    <h4 class="m-0 text-danger text-start"><strong>Document submited and now it under verification!</strong></h4>
                                @elseif(account_verify_document() && account_verify_document()->status == 2)
                                    <h4 class="m-0 text-danger text-start"><strong>Document submited but this information rejected, please submit your valid document again!</strong></h4>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <div>
                                <h5>Attention Please</h5>
                                <ul>
                                    <li> <strong>Img section - </strong>Don't Use copy Img.</li>
                                    <li> <strong>Document section -</strong> Don't upload fack or edited Document .</li>
                                    <li> <strong> Verification Documents -</strong> Always use real and clear img for Verification.</li>
                                    <li> <strong>Ban Warning -</strong> If you uplaod fack or edited document then your account will be permanently Ban without any warning.</li>
                                </ul>
                            </div>
                            
                            <div class="form-group">
                                <label for="document_type">Select Verify Card*</label>
                                <select class="form-control" name="document_type" id="document_type" required onchange="changeCardType()">
                                    <option value="NID" @if(account_verify_document() && account_verify_document()->document_type == "NID") selected @endif>NID</option>
                                    <option value="Birth Certificate" @if(account_verify_document() && account_verify_document()->document_type == "Birth Certificate") selected @endif>Birth Certificate</option>
                                    <option value="Passport" @if(account_verify_document() && account_verify_document()->document_type == "Passport") selected @endif>Passport</option>
                                    <option value="Driving License" @if(account_verify_document() && account_verify_document()->document_type == "Driving License") selected @endif>Driving License</option>
                                </select>
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="name">Full Name*</label>
                                <input type="text" class="form-control" name="name" required placeholder="Name which used for this account." @if(account_verify_document()) value="{{account_verify_document()->name}}" @endif>
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="card_number">Card Number*</label>
                                <input type="text" class="form-control" name="card_number" required placeholder="Card Number." @if(account_verify_document()) value="{{account_verify_document()->card_number}}" @endif>
                            </div>
                            
                            <div class="form-group mt-2 card-sample" id="id_card_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/nid.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2 card-sample d-none" id="birth_certificate_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/passport.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2 card-sample d-none" id="passport_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/driver.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2 card-sample d-none" id="driving_sample">
                                <div style="text-align:center"><img id="imgTypeDemo" class="typeDemoImg" src="https://workupjob.com/assets/billing/bio.jpg"></div>
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="document_front">*Card এর প্রথম পেজ যেখানে আপনার নাম রয়েছে</label>
                                <input type="file" class="form-control" name="document_front" id="document_front" required onchange="readDocumentFrontURL();">
                                @if(account_verify_document())
                                    <div style="text-align: center;"><img src="{{ URL::to(account_verify_document()->document_front) }}" class="img-fluid c-pointermt-2" height="60px" width="60px" id="document_front_image" onclick="viewImage('{{URL::to(account_verify_document()->document_front)}}')"></div>
                                @else
                                    <div style="text-align: center;"><img class="rounded border-dark" style="margin-top: 10px;max-height: 200px;" width="150px" id="document_front_image"></div>
                                @endif
                            </div>
                            
                            <div class="form-group mt-2">
                                <label for="document_with_user">*Card আপনার হাতে নিয়ে আপনার মুখ সহ পিক তুলবেন</label>
                                <input type="file" class="form-control" name="document_with_user" id="document_with_user" required onchange="readDocumentWithUserURL();">
                                @if(account_verify_document())
                                    <div style="text-align: center;"><img src="{{ URL::to(account_verify_document()->document_with_user) }}" class="img-fluid c-pointermt-2" height="60px" width="60px" id="document_with_user_image" onclick="viewImage('{{URL::to(account_verify_document()->document_with_user)}}')"></div>
                                @else
                                    <div style="text-align: center;"><img class="rounded border-dark" style="margin-top: 10px;max-height: 200px;" width="150px" id="document_with_user_image"></div>
                                @endif
                            </div>
                        </div>
                        <div class="card-footer text-center">
                            <button type="submit" class="btn btn-outline-success bttn mt-2">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    @endif

@endsection
@section('js')
    <script src="{{ asset('frontend/user/assets/js/my_custom.js') }}"></script>
    <script>
        function changeCardType(){
            var document_type = $('#document_type').val();
            $('.card-sample').addClass('d-none');
            if(document_type == 'NID'){
                $('#id_card_sample').removeClass('d-none');
            }else if(document_type == 'Birth Certificate'){
                $('#birth_certificate_sample').removeClass('d-none');
            }else if(document_type == 'Passport'){
                $('#passport_sample').removeClass('d-none');
            }else if(document_type == 'Driving License'){
                $('#driving_sample').removeClass('d-none');
            }
        }
        
        function readDocumentFrontURL(){
            var file = $('#document_front').get(0).files[0];
            console.log(file);
            if(file){
                $('#document_front_image').show();
                var reader = new FileReader();

                reader.onload = function(){
                    $('#document_front_image').attr("src", reader.result);
                }

                reader.readAsDataURL(file);
            }
        }
        
        function readDocumentWithUserURL(){
            var file = $('#document_with_user').get(0).files[0];
            console.log(file);
            if(file){
                $('#document_with_user_image').show();
                var reader = new FileReader();

                reader.onload = function(){
                    $('#document_with_user_image').attr("src", reader.result);
                }

                reader.readAsDataURL(file);
            }
        }
    </script>
@endsection
